#version 430

layout (location = 0) in smooth vec3 fragViewPos;
layout (location = 1) in smooth vec3 fragNormal;
layout (location = 2) in vec2 fragTexCoords;
layout (location = 3) in vec4 fragPosLightSpace;
layout (location = 4) flat in uvec3 fragInstanceID;
layout (location = 5) in float colorBrightness;
layout (location = 6) in vec3 fragLocalPos;
layout (location = 7) in vec2 fragRobotics_Commandeer;

layout (location = 0) out vec4 gAlbedoSpec;
layout (location = 1) out vec4 gViewPosition; //last one is also depth
layout (location = 2) out vec3 gNormal;
layout (location = 3) out vec4 gShadowVisibility;
layout (location = 4) out vec2 gInstanceID;
layout (location = 5) out vec4 gPhysical;

layout (binding = 1) uniform sampler2D rgbTexture;
layout (binding = 2) uniform sampler2D physicalTexture;

layout(binding = 1, rgba16f) uniform readonly restrict image2D playerTex;


uniform mat4 view;

uniform int sunID;
uniform int modelID;

uniform vec3 lightDir; //remove this
uniform float time;

float linearize_depth(float d,float zNear,float zFar)
{
  float z_n = 2.0 * d - 1.0;
  return 2.0 * zNear * zFar / (zFar + zNear - z_n * (zFar - zNear));
}

bool getIsMetalMaterial(){

	bool isMatte = true;

	if(fragTexCoords.x < 0.5){
		isMatte = false;
	}

	bool isGlass = true;

	if(fragTexCoords.x > 0.166){
		isGlass = false;
	}

	if(isGlass && fragTexCoords.y > 0.33){
		isGlass = false;
	}

	return isMatte || isGlass;
}




#define NUM_OCTAVES 5

float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }

float noise(vec3 x) {
	const vec3 step = vec3(110, 241, 171);

	vec3 i = floor(x);
	vec3 f = fract(x);
 
	// For performance, compute the base input to a 1D hash from the integer part of the argument and the 
	// incremental change to the 1D based on the 3D -> 1D wrapping
    float n = dot(i, step);

	vec3 u = f * f * (3.0 - 2.0 * f);
	return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y),
               mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z);
}
float fbm (vec3 _st) {
    float v = 0.0;
    float a = 0.5;
    vec3 shift = vec3(100.0f);
    // Rotate to reduce axial bias
    mat2 rot = mat2(cos(0.5), sin(0.5),
                    -sin(0.5), cos(0.50));
    for (int i = 0; i < NUM_OCTAVES; ++i) {
        v += a * noise(_st);
        _st = _st * 2.0 + shift;
        a *= 0.5;
    }
    return v;
}

void main(){
 
//do shadow visibility here

	gShadowVisibility.xyz = (fragPosLightSpace.xyz / fragPosLightSpace.w) * 0.5 + 0.5;

	float playerID = float(fragInstanceID.z);

	vec4 albedoOutput = vec4(texture(rgbTexture, fragTexCoords.xy));
	vec4 physicalOutput = vec4(texture(physicalTexture, fragTexCoords.xy));


	if(getIsMetalMaterial() && fragRobotics_Commandeer.x > 0){
	
		float noiseFreq = 0.5f;

		float firstNoise = fbm(fragLocalPos * noiseFreq);

		float finalNoise = abs(sin(time * 5.0 + firstNoise * 10.0f));

		finalNoise -= (1.0 - 0.05 * fragRobotics_Commandeer.x);

		finalNoise /= 0.05;

		finalNoise = clamp(finalNoise, 0.0, 1.0);

		albedoOutput = mix(albedoOutput, vec4(imageLoad(playerTex, ivec2(1, int(playerID - 1))).xyz, 1.0), finalNoise);

		physicalOutput.z = finalNoise * colorBrightness;

	}

	gAlbedoSpec.xyzw = albedoOutput;

	gPhysical.xyzw = physicalOutput;

	bool isItEmissive = physicalOutput.z > 0.0;

	if(isItEmissive){
		gPhysical.z = 1.0 * colorBrightness;
	}

	 if(texture(physicalTexture, fragTexCoords.xy).y > 0.1 && playerID != 0.0){

		if(fract(fragRobotics_Commandeer.y) > 0.0){
			
			float noiseFreq = 0.5f;

			float offsetValue = abs(fbm(fragLocalPos * noiseFreq));

			int colorID;
			
			if(offsetValue + fract(fragRobotics_Commandeer.y) > 1.1){
				colorID = int(playerID);
			} else{
				colorID = int(floor(fragRobotics_Commandeer.y));
			}

			if(isItEmissive){
				gAlbedoSpec.xyz = vec4(imageLoad(playerTex, ivec2(1, int(colorID - 1)))).xyz;
			}else{
				gAlbedoSpec.xyz = vec4(imageLoad(playerTex, ivec2(0, int(colorID - 1)))).xyz;
			}


		}else{
			if(isItEmissive){
				gAlbedoSpec.xyz = vec4(imageLoad(playerTex, ivec2(1, int(playerID - 1)))).xyz;
			}else{
				gAlbedoSpec.xyz = vec4(imageLoad(playerTex, ivec2(0, int(playerID - 1)))).xyz;
			}
		}
	 }

	gViewPosition.xyz = fragViewPos.xyz;

	gViewPosition.w = linearize_depth(gl_FragCoord.z, 1.0, 6000);

	gNormal = normalize(fragNormal.xyz);
	gInstanceID = fragInstanceID.xy;

	if(int(fragInstanceID.x) == sunID){
	
		gPhysical.z = 10.0f;
		gNormal = vec3(0.0);
		gAlbedoSpec.xyz = vec3(1.0, 1.0, 1.0); //add in the sun color ehre in the future
	}


	
}